<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
* @filesource
*//** */


// This can be removed if you use __autoload() in config.php OR use Modular Extensions
require_once APPPATH.'libraries/DaaS_REST_Controller.php';
require_once APPPATH.'models/user.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Admin extends DaaS_REST_Controller
{
	public function __construct() {	
		parent::__construct();
		if (!$this->request->admin_api_authorized) { //authorize request
			$this->response( 'Access Denied. Use Not Authorized.', 403);
		}
	}
	public function create_user_post() {		
		
		$this->load->model( 'usersmodel' );
		
		//check parameters for required fields, set defaults for non-required fields that aren't provided
		//TO-DO: username / id should be automatically determined somehow (or at least restricted more) -- id is org id and should be pulled from a certificate ideally
		if(!$this->post('username')) { $this->missing_required_fields[] = 'username'; } else { $username = $this->post('username'); }
		if(!$this->post('id')) { $this->missing_required_fields[] = 'id'; } else { $id = $this->post('id'); }
		if(!$this->post('first')) { $this->missing_required_fields[] = 'first_name'; } else { $first = $this->post('first'); }
		if(!$this->post('last')) { $this->missing_required_fields[] = 'last_name'; } else { $last = $this->post('last'); }
		if(!$this->post('middle')) { $middle = null; } else { $middle = $this->post('middle'); }
		if(!$this->post('mail')) { $ext_mail = ''; } else { $ext_mail = $this->post('mail'); }
		if(!$this->post('title')) { $title = null; } else { $title = $this->post('title'); }
		if(!$this->post('department')) { $department = null; } else { $department = $this->post('department'); }
		if(!$this->post('organization')) { $organization = null; } else { $organization = $this->post('organization'); }
		if(!$this->post('telephone')) { $telephone = null; } else { $telephone = $this->post('telephone'); }
		if(!$this->post('mobile')) { $mobile = null; } else { $mobile = $this->post('mobile'); }
		if(!$this->post('location')) { $location = null; } else { $location = $this->post('location'); }
		if(!$this->post('facility_id')) { $facility_id = null; } else { $facility_id = $this->post('facility_id'); }
		
		$this->respond_with_error_if_fields_are_missing(); 
	
#TODO - WE USUALLY GIVE 422 FOR INVALID DATA.  SHOULD USERNAME/ORG ID ALREADY IN USE FALL INTO THIS CASE?	
		if(User::exists(compact('username'))) $this->response('Bad Request. Username already in use.', 400);
		if(User::exists( array('user_org_id' => $id) )){
			if($this->usersmodel->org_id_linked($id,$this->application_id)) $this->response( 'Bad Request. User ID already in use by this application.', 400 );
			$this->response('Bad Request. User ID already in use, but not linked to this application.', 400);
		} 
		
		//make sure the username is suitable for an email address
		if(!$this->is->string_like_an_email_address($username.'@'.DIRECT_DOMAIN)) $this->invalid_fields[] = 'username';
		if(!empty($ext_mail) && !$this->is->string_like_an_email_address($ext_mail)) 
			$this->invalid_fields[] = 'mail';
		
		$this->respond_with_error_if_fields_are_invalid();
		
		//set LDAP attributes
		$attributes = array(
			'givenName' => $first,
			'sn' => $last,
			'cn' => $first.' '.$last,
		);
		//set optional attributes / attributes that depend on optional attributes
		if(!empty($middle)) { 
			$attributes['initials'] = $middle;
			$attributes['displayName'] = $last.', '.$first.' '.$middle;							
		}
#		#else { $attributes['displayName'] = $last.', '.$first; }	//create_user will handle the default case
		if(!empty($title)) { $attributes['title'] = $title; }
		if(!empty($department)) { $attributes['departmentNumber'] = $department; }
		if(!empty($organization)) { $attributes['o'] = $organization; }
		if(!empty($telephone)) { $attributes['telephoneNumber'] = $telephone; }
		if(!empty($mobile)) { $attributes['mobile'] = $mobile; }
		if(!empty($location)) { $attributes['physicalDeliveryOfficeName'] = $location; }
		
		$user = $this->usersmodel->create_user($username,$this->application_id,$id,$ext_mail,$facility_id,$attributes);
		if(User::is_an_entity($user)){
			//set up user settings 
			#$user_id = $this->usersmodel->get_user_id_from_org_id($id);
			#$this->load->model('usersettingsmodel');
			#$this->usersettingsmodel->user_settings_setup($user_id, $this->application_id); //THIS METHOD DOESN'T SEEM TO EXIST ANYMORE - WE WANT THIS ON THE CREATE_USER METHOD ANYWAY
			$this->response_message['username'] = $user->username;
			$this->response('User successfully created.', 200);
		}
		
		$this->response('Failed to create user.', 500);
	}
	
	/*Create Group webcall*/
	public function create_group_post() {		
		//check parameters for required fields, set defaults for non-required fields that aren't provided
		//TO-DO: username / id should be automatically determined somehow (or at least restricted more) -- id is org id and should be pulled from a certificate ideally
		if(!$this->post('group_name')) { $this->missing_required_fields[] = 'group_name'; } else { $group_name = $this->post('group_name'); }
		if(!$this->post('display_name')) { $this->missing_required_fields[] = 'display_name'; } else { $display_name = $this->post('display_name'); }
		if(!$this->post('description')) { $this->missing_required_fields[] = 'description'; } else { $description = $this->post('description'); }
		if(!$this->post('facility')) { $facility_id = null; } else { $facility_id = $this->post('facility'); }
		$this->respond_with_error_if_fields_are_missing();
		
		//if authorized perform user creation
		$this->load->model( array('usersettingsmodel','usersmodel', 'groupsmodel', 'applicationmodel' ) );
		if($this->usersmodel->username_exists($group_name) || Mailbox::exists( array('name' => $group_name) )){ 
			
			$this->load->model('applicationmodel');
			$apps = $this->groupsmodel->get_applications($group_name);
			$query = $this->applicationmodel->get_application($this->application_id);
			if($query && $query->num_rows() === 1) {
				$row = $query->row_array(0);
				if(in_array($row['name'], $apps)){
					$this->response('Application already has group', 200);
				}
			}
			$this->response( 'Bad Request. Name already in use.', 400);
		}
		
		if(!$this->is->string_like_an_email_address($group_name.'@'.DIRECT_DOMAIN)) $this->invalid_fields[] = 'group_name';
		if(!$this->is->nonempty_string($display_name)) $this->invalid_fields[] = 'display_name';
		if(!$this->is->nonempty_string($description)) $this->invalid_fields[] = 'description';
		$this->respond_with_error_if_fields_are_invalid();		
		
		if($this->groupsmodel->create_group($group_name,$this->application_id,$display_name,$description)) {
			$this->usersettingsmodel->update_facility_id_in_mailbox($group_name, true, $facility_id);
			$this->response_message['group_name'] = $group_name;
			$mailbox_id = $this->usersettingsmodel->get_mailbox_id_by_name($group_name, true);
			$mailbox_settings = $this->usersettingsmodel->get_web_services()->result();
			foreach($mailbox_settings as $setting) {
				if($this->post($setting->name)){
					$authorized = 'on';
				} 
				else{
					$authorized = false;
				}
				($this->usersettingsmodel->save_mailbox_settings_entry($mailbox_id, $this->application_id, $setting->id, $authorized));
			}
			
			$this->response('Group successfully created.', 200);
		}else {
			$this->response('Failed to create group.', 500);
		}
	}
	
	public function facilities_get(){
		$this->load->model('facilitymodel');
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_fields_are_invalid();
		$response_message['facilities'] = $this->facilitymodel->get_facilities(true)->result();
		$this->response($response_message, 200);
	}
	
	public function web_services_get(){
		$this->load->model('usersettingsmodel');
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_fields_are_invalid();
		$response_message['services'] = $this->usersettingsmodel->get_web_services()->result();
		$this->response($response_message, 200);
	}
	/* This function retrieves information about a request
	 */
	public function requeststatus_get(){

		if(!$this->get('requestid')) {
			$this->response('Must provide a request id.', 422);
		}

		$request_id = $this->get('requestid');
		if(!$this->is->nonzero_unsigned_integer($request_id)) 
			$this->invalid_fields[] = 'requestid';
		
		$this->respond_with_error_if_fields_are_invalid();		
		
		$query = $this->requestmodel->get_request_by_id($request_id);
		if ($query->num_rows == 0){
			$this->response('No request found with id '.$request_id.'.', 422);
		}
		$query_array = $query->row_array();
		
		if ($this->application_id !== $query_array['application_id']){
			$this->response('Access Denied. You do not have access to this request status.', 422);
		}
		
		$response_message['request_row'] = $query_array;
		$this->response($response_message, 200);
	}
}
